﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class Loading : MonoBehaviour
{
    private bool _LoadingScene = false; //Flag if we're currently loading a scene
    private static int _SceneIndex; //Index of the scene to load
    private static string _SceneName;   //Name of the scene to load
    private static bool _LoadByName = false;    //Flag for loading by name or index


    private void Update()
    {
        if (!_LoadingScene)
        {
            //We're now loading, start the load
            _LoadingScene = true;
            StartCoroutine(LoadScene());
        }
    }

    public static void SetSceneToLoad(string sceneName)
    {
        _SceneName = sceneName;
        _SceneIndex = -1;
        _LoadByName = true;
    }

    public static void SetSceneToLoad(int index)
    {
        _SceneIndex = index;
        _SceneName = null;
        _LoadByName = false;
    }

    private IEnumerator LoadScene()
    {
        AsyncOperation async;

        if (_LoadByName)
        {
            //Load by name
            async = SceneManager.LoadSceneAsync(_SceneName);
        }

        else
        {
            //Load by index
            async = SceneManager.LoadSceneAsync(_SceneIndex);
        }

        //Wait until the load is done
        while (!async.isDone)
        {
            yield return null;
        }

        yield return async;
    }
}
